//
//  FirstLevelViewController.m
//  Nav
//
//  Created by Robert Górczyński on 11-07-04.
//

#import "FirstLevelViewController.h"
#import "SecondLevelViewController.h"
#import "DisclosureButtonController.h"
#import "CheckListController.h"
#import "RowControlsController.h"
#import "MoveMeController.h"
#import "DeleteMeController.h"
#import "PresidentsViewController.h"


@implementation FirstLevelViewController

@synthesize controllers;

- (void)viewDidLoad { 
	self.title = @"Poziom pierwszy"; 
	NSMutableArray *array = [[NSMutableArray alloc] init];
	
	// Przycisk typu disclosure 
    DisclosureButtonController *disclosureButtonController = 
	[[DisclosureButtonController alloc] 
	 initWithStyle:UITableViewStylePlain]; 
    disclosureButtonController.title = @"Przyciski typu disclosure"; 
    disclosureButtonController.rowImage = [UIImage 
										   imageNamed:@"disclosureButtonControllerIcon.png"]; 
    [array addObject:disclosureButtonController]; 
    [disclosureButtonController release];
	
	// Lista wyboru
    CheckListController *checkListController = [[CheckListController alloc] 
												initWithStyle:UITableViewStylePlain]; 
    checkListController.title = @"Wybierz jeden element"; 
    checkListController.rowImage = [UIImage imageNamed: 
									@"checkmarkControllerIcon.png"]; 
    [array addObject:checkListController]; 
    [checkListController release]; 
	
	// Kontrolki w rekordzie tabeli 
    RowControlsController *rowControlsController = 
	[[RowControlsController alloc] 
	 initWithStyle:UITableViewStylePlain]; 
    rowControlsController.title = @"Kontrolki w rekordzie"; 
    rowControlsController.rowImage = [UIImage imageNamed: 
									  @"rowControlsIcon.png"]; 
    [array addObject:rowControlsController]; 
    [rowControlsController release]; 
	
	// Ruchome rekordy 
    MoveMeController *moveMeController = [[MoveMeController alloc] 
										  initWithStyle:UITableViewStylePlain]; 
    moveMeController.title = @"Ruchome rekordy"; 
    moveMeController.rowImage = [UIImage imageNamed:@"moveMeIcon.png"]; 
    [array addObject:moveMeController]; 
    [moveMeController release]; 
	
	// Rekordy do usunięcia 
    DeleteMeController *deleteMeController = [[DeleteMeController alloc] 
											  initWithStyle:UITableViewStylePlain]; 
    deleteMeController.title = @"Usuń rekord"; 
    deleteMeController.rowImage = [UIImage imageNamed:@"deleteMeIcon.png"]; 
    [array addObject:deleteMeController]; 
    [deleteMeController release]; 
	
	// Widok President 
    PresidentsViewController *presidentsViewController = 
	[[PresidentsViewController alloc] 
	 initWithStyle:UITableViewStylePlain]; 
    presidentsViewController.title = @"Edycja szczegółów"; 
    presidentsViewController.rowImage = [UIImage imageNamed: 
										 @"detailEditIcon.png"]; 
    [array addObject:presidentsViewController]; 
    [presidentsViewController release]; 	
	
	self.controllers = array; 
	[array release]; 
	[super viewDidLoad]; 
} 

- (void)viewDidUnload { 
	self.controllers = nil; 
	[super viewDidUnload]; 
} 

- (void)dealloc { 
	[controllers release]; 
	[super dealloc]; 
} 

#pragma mark - 
#pragma mark Metody źródła danych tabeli 
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [self.controllers count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
         cellForRowAtIndexPath:(NSIndexPath *)indexPath { 
	
    static NSString *FirstLevelCell= @"FirstLevelCell"; 
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
                             FirstLevelCell]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier: FirstLevelCell] autorelease]; 
    } 
    // Konfiguracja komórki tabeli 
    NSUInteger row = [indexPath row]; 
    SecondLevelViewController *controller = 
	[controllers objectAtIndex:row]; 
    cell.textLabel.text = controller.title; 
    cell.imageView.image = controller.rowImage;
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator; 
    return cell; 
} 

#pragma mark - 
#pragma mark Metody delegata widoku tabeli 
- (void)tableView:(UITableView *)tableView 
didSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger row = [indexPath row]; 
    SecondLevelViewController *nextController = [self.controllers 
                                                 objectAtIndex:row]; 
    [self.navigationController pushViewController:nextController 
                                         animated:YES]; 
}

@end
